/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.wrapper;

import iaik.pkcs.pkcs11.wrapper.CK_DATE;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Hashtable;

public class Functions {
    protected static Hashtable mechansimNames_;
    protected static Hashtable fullEncryptDecryptMechanisms_;
    protected static Hashtable singleOperationEncryptDecryptMechanisms_;
    protected static Hashtable fullSignVerifyMechanisms_;
    protected static Hashtable singleOperationSignVerifyMechanisms_;
    protected static Hashtable signVerifyRecoverMechanisms_;
    protected static Hashtable digestMechanisms_;
    protected static Hashtable keyGenerationMechanisms_;
    protected static Hashtable keyPairGenerationMechanisms_;
    protected static Hashtable wrapUnwrapMechanisms_;
    protected static Hashtable keyDerivationMechanisms_;
    protected static final char[] HEX_DIGITS;

    static {
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }

    public static String classTypeToString(long l) {
        String string = l == 0L ? "CKO_DATA" : (l == 1L ? "CKO_CERTIFICATE" : (l == 2L ? "CKO_PUBLIC_KEY" : (l == 3L ? "CKO_PRIVATE_KEY" : (l == 4L ? "CKO_SECRET_KEY" : (l == 5L ? "CKO_HW_FEATURE" : (l == 6L ? "CKO_DOMAIN_PARAMETERS" : (l == 0x80000000L ? "CKO_VENDOR_DEFINED" : "ERROR: unknown classType with code: 0x" + Functions.toFullHexString(l))))))));
        return string;
    }

    public static boolean equals(CK_DATE cK_DATE, CK_DATE cK_DATE2) {
        boolean bl = false;
        bl = cK_DATE == cK_DATE2 ? true : (cK_DATE != null && cK_DATE2 != null ? Functions.equals(cK_DATE.year, cK_DATE2.year) && Functions.equals(cK_DATE.month, cK_DATE2.month) && Functions.equals(cK_DATE.day, cK_DATE2.day) : false);
        return bl;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        boolean bl = false;
        if (byArray == byArray2) {
            bl = true;
        } else if (byArray != null && byArray2 != null) {
            int n = byArray.length;
            if (n == byArray2.length) {
                bl = true;
                int n2 = 0;
                while (n2 < n) {
                    if (byArray[n2] != byArray2[n2]) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean equals(char[] cArray, char[] cArray2) {
        boolean bl = false;
        if (cArray == cArray2) {
            bl = true;
        } else if (cArray != null && cArray2 != null) {
            int n = cArray.length;
            if (n == cArray2.length) {
                bl = true;
                int n2 = 0;
                while (n2 < n) {
                    if (cArray[n2] != cArray2[n2]) {
                        bl = false;
                        break;
                    }
                    ++n2;
                }
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static int hashCode(CK_DATE cK_DATE) {
        int n = 0;
        if (cK_DATE != null) {
            if (cK_DATE.year.length == 4) {
                n ^= (0xFFFF & cK_DATE.year[0]) << 16;
                n ^= 0xFFFF & cK_DATE.year[1];
                n ^= (0xFFFF & cK_DATE.year[2]) << 16;
                n ^= 0xFFFF & cK_DATE.year[3];
            }
            if (cK_DATE.month.length == 2) {
                n ^= (0xFFFF & cK_DATE.month[0]) << 16;
                n ^= 0xFFFF & cK_DATE.month[1];
            }
            if (cK_DATE.day.length == 2) {
                n ^= (0xFFFF & cK_DATE.day[0]) << 16;
                n ^= 0xFFFF & cK_DATE.day[1];
            }
        }
        return n;
    }

    public static int hashCode(byte[] byArray) {
        int n = 0;
        if (byArray != null) {
            int n2 = 0;
            while (n2 < 4 && n2 < byArray.length) {
                n ^= (0xFF & byArray[n2]) << (n2 % 4 << 3);
                ++n2;
            }
        }
        return n;
    }

    public static int hashCode(char[] cArray) {
        int n = 0;
        if (cArray != null) {
            int n2 = 0;
            while (n2 < 4 && n2 < cArray.length) {
                n ^= (0xFFFF & cArray[n2]) << (n2 % 2 << 4);
                ++n2;
            }
        }
        return n;
    }

    public static boolean isDigestMechanism(long l) {
        if (digestMechanisms_ == null) {
            Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
            hashtable.put(new Long(512L), "CKM_MD2");
            hashtable.put(new Long(528L), "CKM_MD5");
            hashtable.put(new Long(544L), "CKM_SHA_1");
            hashtable.put(new Long(560L), "CKM_RIPEMD128");
            hashtable.put(new Long(576L), "CKM_RIPEMD160");
            hashtable.put(new Long(4208L), "CKM_FASTHASH");
            digestMechanisms_ = hashtable;
        }
        return digestMechanisms_.containsKey(new Long(l));
    }

    public static boolean isFullEncryptDecryptMechanism(long l) {
        if (fullEncryptDecryptMechanisms_ == null) {
            Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
            hashtable.put(new Long(257L), "CKM_RC2_ECB");
            hashtable.put(new Long(258L), "CKM_RC2_CBC");
            hashtable.put(new Long(261L), "CKM_RC2_CBC_PAD");
            hashtable.put(new Long(273L), "CKM_RC4");
            hashtable.put(new Long(289L), "CKM_DES_ECB");
            hashtable.put(new Long(290L), "CKM_DES_CBC");
            hashtable.put(new Long(293L), "CKM_DES_CBC_PAD");
            hashtable.put(new Long(306L), "CKM_DES3_ECB");
            hashtable.put(new Long(307L), "CKM_DES3_CBC");
            hashtable.put(new Long(310L), "CKM_DES3_CBC_PAD");
            hashtable.put(new Long(321L), "CKM_CDMF_ECB");
            hashtable.put(new Long(322L), "CKM_CDMF_CBC");
            hashtable.put(new Long(325L), "CKM_CDMF_CBC_PAD");
            hashtable.put(new Long(769L), "CKM_CAST_ECB");
            hashtable.put(new Long(770L), "CKM_CAST_CBC");
            hashtable.put(new Long(773L), "CKM_CAST_CBC_PAD");
            hashtable.put(new Long(785L), "CKM_CAST3_ECB");
            hashtable.put(new Long(786L), "CKM_CAST3_CBC");
            hashtable.put(new Long(789L), "CKM_CAST3_CBC_PAD");
            hashtable.put(new Long(801L), "CKM_CAST5_ECB");
            hashtable.put(new Long(801L), "CKM_CAST128_ECB");
            hashtable.put(new Long(802L), "CKM_CAST5_CBC");
            hashtable.put(new Long(802L), "CKM_CAST128_CBC");
            hashtable.put(new Long(805L), "CKM_CAST5_CBC_PAD");
            hashtable.put(new Long(805L), "CKM_CAST128_CBC_PAD");
            hashtable.put(new Long(817L), "CKM_RC5_ECB");
            hashtable.put(new Long(818L), "CKM_RC5_CBC");
            hashtable.put(new Long(821L), "CKM_RC5_CBC_PAD");
            hashtable.put(new Long(4225L), "CKM_AES_ECB");
            hashtable.put(new Long(4226L), "CKM_AES_CBC");
            hashtable.put(new Long(4229L), "CKM_AES_CBC_PAD");
            hashtable.put(new Long(833L), "CKM_IDEA_ECB");
            hashtable.put(new Long(834L), "CKM_IDEA_CBC");
            hashtable.put(new Long(837L), "CKM_IDEA_CBC_PAD");
            hashtable.put(new Long(4097L), "CKM_SKIPJACK_ECB64");
            hashtable.put(new Long(4098L), "CKM_SKIPJACK_CBC64");
            hashtable.put(new Long(4099L), "CKM_SKIPJACK_OFB64");
            hashtable.put(new Long(4100L), "CKM_SKIPJACK_CFB64");
            hashtable.put(new Long(4101L), "CKM_SKIPJACK_CFB32");
            hashtable.put(new Long(4102L), "CKM_SKIPJACK_CFB16");
            hashtable.put(new Long(4103L), "CKM_SKIPJACK_CFB8");
            hashtable.put(new Long(4145L), "CKM_BATON_ECB128");
            hashtable.put(new Long(4146L), "CKM_BATON_ECB96");
            hashtable.put(new Long(4147L), "CKM_BATON_CBC128");
            hashtable.put(new Long(4148L), "CKM_BATON_COUNTER");
            hashtable.put(new Long(4149L), "CKM_BATON_SHUFFLE");
            hashtable.put(new Long(4193L), "CKM_JUNIPER_ECB128");
            hashtable.put(new Long(4194L), "CKM_JUNIPER_CBC128");
            hashtable.put(new Long(4195L), "CKM_JUNIPER_COUNTER");
            hashtable.put(new Long(4196L), "CKM_JUNIPER_SHUFFLE");
            fullEncryptDecryptMechanisms_ = hashtable;
        }
        return fullEncryptDecryptMechanisms_.containsKey(new Long(l));
    }

    public static boolean isFullSignVerifyMechanism(long l) {
        if (fullSignVerifyMechanisms_ == null) {
            Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
            hashtable.put(new Long(4L), "CKM_MD2_RSA_PKCS");
            hashtable.put(new Long(5L), "CKM_MD5_RSA_PKCS");
            hashtable.put(new Long(6L), "CKM_SHA1_RSA_PKCS");
            hashtable.put(new Long(7L), "CKM_RIPEMD128_RSA_PKCS");
            hashtable.put(new Long(8L), "CKM_RIPEMD160_RSA_PKCS");
            hashtable.put(new Long(14L), "CKM_SHA1_RSA_PKCS_PSS");
            hashtable.put(new Long(12L), "CKM_SHA1_RSA_X9_31");
            hashtable.put(new Long(18L), "CKM_DSA_SHA1");
            hashtable.put(new Long(259L), "CKM_RC2_MAC");
            hashtable.put(new Long(260L), "CKM_RC2_MAC_GENERAL");
            hashtable.put(new Long(291L), "CKM_DES_MAC");
            hashtable.put(new Long(292L), "CKM_DES_MAC_GENERAL");
            hashtable.put(new Long(308L), "CKM_DES3_MAC");
            hashtable.put(new Long(309L), "CKM_DES3_MAC_GENERAL");
            hashtable.put(new Long(323L), "CKM_CDMF_MAC");
            hashtable.put(new Long(324L), "CKM_CDMF_MAC_GENERAL");
            hashtable.put(new Long(513L), "CKM_MD2_HMAC");
            hashtable.put(new Long(514L), "CKM_MD2_HMAC_GENERAL");
            hashtable.put(new Long(529L), "CKM_MD5_HMAC");
            hashtable.put(new Long(530L), "CKM_MD5_HMAC_GENERAL");
            hashtable.put(new Long(545L), "CKM_SHA_1_HMAC");
            hashtable.put(new Long(546L), "CKM_SHA_1_HMAC_GENERAL");
            hashtable.put(new Long(561L), "CKM_RIPEMD128_HMAC");
            hashtable.put(new Long(562L), "CKM_RIPEMD128_HMAC_GENERAL");
            hashtable.put(new Long(577L), "CKM_RIPEMD160_HMAC");
            hashtable.put(new Long(578L), "CKM_RIPEMD160_HMAC_GENERAL");
            hashtable.put(new Long(771L), "CKM_CAST_MAC");
            hashtable.put(new Long(772L), "CKM_CAST_MAC_GENERAL");
            hashtable.put(new Long(787L), "CKM_CAST3_MAC");
            hashtable.put(new Long(788L), "CKM_CAST3_MAC_GENERAL");
            hashtable.put(new Long(803L), "CKM_CAST5_MAC");
            hashtable.put(new Long(803L), "CKM_CAST128_MAC");
            hashtable.put(new Long(804L), "CKM_CAST5_MAC_GENERAL");
            hashtable.put(new Long(804L), "CKM_CAST128_MAC_GENERAL");
            hashtable.put(new Long(819L), "CKM_RC5_MAC");
            hashtable.put(new Long(820L), "CKM_RC5_MAC_GENERAL");
            hashtable.put(new Long(4227L), "CKM_AES_MAC");
            hashtable.put(new Long(4228L), "CKM_AES_MAC_GENERAL");
            hashtable.put(new Long(835L), "CKM_IDEA_MAC");
            hashtable.put(new Long(836L), "CKM_IDEA_MAC_GENERAL");
            hashtable.put(new Long(896L), "CKM_SSL3_MD5_MAC");
            hashtable.put(new Long(897L), "CKM_SSL3_SHA1_MAC");
            hashtable.put(new Long(4162L), "CKM_ECDSA_SHA1");
            fullSignVerifyMechanisms_ = hashtable;
        }
        return fullSignVerifyMechanisms_.containsKey(new Long(l));
    }

    public static boolean isKeyDerivationMechanism(long l) {
        if (keyDerivationMechanisms_ == null) {
            Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
            hashtable.put(new Long(33L), "CKM_DH_PKCS_DERIVE");
            hashtable.put(new Long(864L), "CKM_CONCATENATE_BASE_AND_KEY");
            hashtable.put(new Long(866L), "CKM_CONCATENATE_BASE_AND_DATA");
            hashtable.put(new Long(867L), "CKM_CONCATENATE_DATA_AND_BASE");
            hashtable.put(new Long(868L), "CKM_XOR_BASE_AND_DATA");
            hashtable.put(new Long(869L), "CKM_EXTRACT_KEY_FROM_KEY");
            hashtable.put(new Long(881L), "CKM_SSL3_MASTER_KEY_DERIVE");
            hashtable.put(new Long(883L), "CKM_SSL3_MASTER_KEY_DERIVE_DH");
            hashtable.put(new Long(882L), "CKM_SSL3_KEY_AND_MAC_DERIVE");
            hashtable.put(new Long(885L), "CKM_TLS_MASTER_KEY_DERIVE");
            hashtable.put(new Long(887L), "CKM_TLS_MASTER_KEY_DERIVE_DH");
            hashtable.put(new Long(886L), "CKM_TLS_KEY_AND_MAC_DERIVE");
            hashtable.put(new Long(912L), "CKM_MD5_KEY_DERIVATION");
            hashtable.put(new Long(913L), "CKM_MD2_KEY_DERIVATION");
            hashtable.put(new Long(914L), "CKM_SHA1_KEY_DERIVATION");
            hashtable.put(new Long(4113L), "CKM_KEA_KEY_DERIVE");
            keyDerivationMechanisms_ = hashtable;
        }
        return keyDerivationMechanisms_.containsKey(new Long(l));
    }

    public static boolean isKeyGenerationMechanism(long l) {
        if (keyGenerationMechanisms_ == null) {
            Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
            hashtable.put(new Long(8192L), "CKM_DSA_PARAMETER_GEN");
            hashtable.put(new Long(8193L), "CKM_DH_PKCS_PARAMETER_GEN");
            hashtable.put(new Long(8194L), "CKM_X9_42_DH_PARAMETER_GEN");
            hashtable.put(new Long(256L), "CKM_RC2_KEY_GEN");
            hashtable.put(new Long(272L), "CKM_RC4_KEY_GEN");
            hashtable.put(new Long(288L), "CKM_DES_KEY_GEN");
            hashtable.put(new Long(304L), "CKM_DES2_KEY_GEN");
            hashtable.put(new Long(305L), "CKM_DES3_KEY_GEN");
            hashtable.put(new Long(320L), "CKM_CDMF_KEY_GEN");
            hashtable.put(new Long(768L), "CKM_CAST_KEY_GEN");
            hashtable.put(new Long(784L), "CKM_CAST3_KEY_GEN");
            hashtable.put(new Long(800L), "CKM_CAST5_KEY_GEN");
            hashtable.put(new Long(800L), "CKM_CAST128_KEY_GEN");
            hashtable.put(new Long(816L), "CKM_RC5_KEY_GEN");
            hashtable.put(new Long(4224L), "CKM_AES_KEY_GEN");
            hashtable.put(new Long(832L), "CKM_IDEA_KEY_GEN");
            hashtable.put(new Long(848L), "CKM_GENERIC_SECRET_KEY_GEN");
            hashtable.put(new Long(880L), "CKM_SSL3_PRE_MASTER_KEY_GEN");
            hashtable.put(new Long(884L), "CKM_TLS_PRE_MASTER_KEY_GEN");
            hashtable.put(new Long(928L), "CKM_PBE_MD2_DES_CBC");
            hashtable.put(new Long(929L), "CKM_PBE_MD5_DES_CBC");
            hashtable.put(new Long(930L), "CKM_PBE_MD5_CAST_CBC");
            hashtable.put(new Long(931L), "CKM_PBE_MD5_CAST3_CBC");
            hashtable.put(new Long(932L), "CKM_PBE_MD5_CAST5_CBC");
            hashtable.put(new Long(932L), "CKM_PBE_MD5_CAST128_CBC");
            hashtable.put(new Long(933L), "CKM_PBE_SHA1_CAST5_CBC");
            hashtable.put(new Long(933L), "CKM_PBE_SHA1_CAST128_CBC");
            hashtable.put(new Long(934L), "CKM_PBE_SHA1_RC4_128");
            hashtable.put(new Long(935L), "CKM_PBE_SHA1_RC4_40");
            hashtable.put(new Long(936L), "CKM_PBE_SHA1_DES3_EDE_CBC");
            hashtable.put(new Long(937L), "CKM_PBE_SHA1_DES2_EDE_CBC");
            hashtable.put(new Long(938L), "CKM_PBE_SHA1_RC2_128_CBC");
            hashtable.put(new Long(939L), "CKM_PBE_SHA1_RC2_40_CBC");
            hashtable.put(new Long(944L), "CKM_PKCS5_PBKD2");
            hashtable.put(new Long(960L), "CKM_PBA_SHA1_WITH_SHA1_HMAC");
            hashtable.put(new Long(4096L), "CKM_SKIPJACK_KEY_GEN");
            hashtable.put(new Long(4144L), "CKM_BATON_KEY_GEN");
            hashtable.put(new Long(4192L), "CKM_JUNIPER_KEY_GEN");
            keyGenerationMechanisms_ = hashtable;
        }
        return keyGenerationMechanisms_.containsKey(new Long(l));
    }

    public static boolean isKeyPairGenerationMechanism(long l) {
        if (keyPairGenerationMechanisms_ == null) {
            Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
            hashtable.put(new Long(0L), "CKM_RSA_PKCS_KEY_PAIR_GEN");
            hashtable.put(new Long(10L), "CKM_RSA_X9_31_KEY_PAIR_GEN");
            hashtable.put(new Long(16L), "CKM_DSA_KEY_PAIR_GEN");
            hashtable.put(new Long(32L), "CKM_DH_PKCS_KEY_PAIR_GEN");
            hashtable.put(new Long(4112L), "CKM_KEA_KEY_PAIR_GEN");
            hashtable.put(new Long(4160L), "CKM_ECDSA_KEY_PAIR_GEN");
            hashtable.put(new Long(4160L), "CKM_EC_KEY_PAIR_GEN");
            hashtable.put(new Long(32L), "CKM_DH_PKCS_KEY_PAIR_GEN");
            hashtable.put(new Long(48L), "CKM_X9_42_DH_KEY_PAIR_GEN");
            keyPairGenerationMechanisms_ = hashtable;
        }
        return keyPairGenerationMechanisms_.containsKey(new Long(l));
    }

    public static boolean isSignVerifyRecoverMechanism(long l) {
        if (signVerifyRecoverMechanisms_ == null) {
            Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
            hashtable.put(new Long(1L), "CKM_RSA_PKCS");
            hashtable.put(new Long(2L), "CKM_RSA_9796");
            hashtable.put(new Long(3L), "CKM_RSA_X_509");
            signVerifyRecoverMechanisms_ = hashtable;
        }
        return signVerifyRecoverMechanisms_.containsKey(new Long(l));
    }

    public static boolean isSingleOperationEncryptDecryptMechanism(long l) {
        if (singleOperationEncryptDecryptMechanisms_ == null) {
            Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
            hashtable.put(new Long(1L), "CKM_RSA_PKCS");
            hashtable.put(new Long(9L), "CKM_RSA_PKCS_OAEP");
            hashtable.put(new Long(3L), "CKM_RSA_X_509");
            singleOperationEncryptDecryptMechanisms_ = hashtable;
        }
        return singleOperationEncryptDecryptMechanisms_.containsKey(new Long(l));
    }

    public static boolean isSingleOperationSignVerifyMechanism(long l) {
        if (singleOperationSignVerifyMechanisms_ == null) {
            Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
            hashtable.put(new Long(1L), "CKM_RSA_PKCS");
            hashtable.put(new Long(13L), "CKM_RSA_PKCS_PSS");
            hashtable.put(new Long(2L), "CKM_RSA_9796");
            hashtable.put(new Long(3L), "CKM_RSA_X_509");
            hashtable.put(new Long(11L), "CKM_RSA_X9_31");
            hashtable.put(new Long(17L), "CKM_DSA");
            hashtable.put(new Long(4128L), "CKM_FORTEZZA_TIMESTAMP");
            hashtable.put(new Long(4161L), "CKM_ECDSA");
            singleOperationSignVerifyMechanisms_ = hashtable;
        }
        return singleOperationSignVerifyMechanisms_.containsKey(new Long(l));
    }

    public static boolean isWrapUnwrapMechanism(long l) {
        if (wrapUnwrapMechanisms_ == null) {
            Hashtable<Long, String> hashtable = new Hashtable<Long, String>();
            hashtable.put(new Long(1L), "CKM_RSA_PKCS");
            hashtable.put(new Long(3L), "CKM_RSA_X_509");
            hashtable.put(new Long(9L), "CKM_RSA_PKCS_OAEP");
            hashtable.put(new Long(257L), "CKM_RC2_ECB");
            hashtable.put(new Long(258L), "CKM_RC2_CBC");
            hashtable.put(new Long(261L), "CKM_RC2_CBC_PAD");
            hashtable.put(new Long(289L), "CKM_DES_ECB");
            hashtable.put(new Long(290L), "CKM_DES_CBC");
            hashtable.put(new Long(293L), "CKM_DES_CBC_PAD");
            hashtable.put(new Long(306L), "CKM_DES3_ECB");
            hashtable.put(new Long(307L), "CKM_DES3_CBC");
            hashtable.put(new Long(310L), "CKM_DES3_CBC_PAD");
            hashtable.put(new Long(321L), "CKM_CDMF_ECB");
            hashtable.put(new Long(322L), "CKM_CDMF_CBC");
            hashtable.put(new Long(325L), "CKM_CDMF_CBC_PAD");
            hashtable.put(new Long(769L), "CKM_CAST_ECB");
            hashtable.put(new Long(770L), "CKM_CAST_CBC");
            hashtable.put(new Long(773L), "CKM_CAST_CBC_PAD");
            hashtable.put(new Long(785L), "CKM_CAST3_ECB");
            hashtable.put(new Long(786L), "CKM_CAST3_CBC");
            hashtable.put(new Long(789L), "CKM_CAST3_CBC_PAD");
            hashtable.put(new Long(801L), "CKM_CAST5_ECB");
            hashtable.put(new Long(801L), "CKM_CAST128_ECB");
            hashtable.put(new Long(802L), "CKM_CAST5_CBC");
            hashtable.put(new Long(802L), "CKM_CAST128_CBC");
            hashtable.put(new Long(805L), "CKM_CAST5_CBC_PAD");
            hashtable.put(new Long(805L), "CKM_CAST128_CBC_PAD");
            hashtable.put(new Long(817L), "CKM_RC5_ECB");
            hashtable.put(new Long(818L), "CKM_RC5_CBC");
            hashtable.put(new Long(821L), "CKM_RC5_CBC_PAD");
            hashtable.put(new Long(833L), "CKM_IDEA_ECB");
            hashtable.put(new Long(834L), "CKM_IDEA_CBC");
            hashtable.put(new Long(837L), "CKM_IDEA_CBC_PAD");
            hashtable.put(new Long(1024L), "CKM_KEY_WRAP_LYNKS");
            hashtable.put(new Long(1025L), "CKM_KEY_WRAP_SET_OAEP");
            hashtable.put(new Long(4104L), "CKM_SKIPJACK_WRAP");
            hashtable.put(new Long(4105L), "CKM_SKIPJACK_PRIVATE_WRAP");
            hashtable.put(new Long(4106L), "CKM_SKIPJACK_RELAYX");
            hashtable.put(new Long(4150L), "CKM_BATON_WRAP");
            hashtable.put(new Long(4197L), "CKM_JUNIPER_WRAP");
            wrapUnwrapMechanisms_ = hashtable;
        }
        return wrapUnwrapMechanisms_.containsKey(new Long(l));
    }

    public static String mechanismCodeToString(long l) {
        Object v;
        Serializable serializable;
        if (mechansimNames_ == null) {
            serializable = new Hashtable(160);
            ((Hashtable)serializable).put(new Long(0L), "CKM_RSA_PKCS_KEY_PAIR_GEN");
            ((Hashtable)serializable).put(new Long(1L), "CKM_RSA_PKCS");
            ((Hashtable)serializable).put(new Long(2L), "CKM_RSA_9796");
            ((Hashtable)serializable).put(new Long(3L), "CKM_RSA_X_509");
            ((Hashtable)serializable).put(new Long(4L), "CKM_MD2_RSA_PKCS");
            ((Hashtable)serializable).put(new Long(5L), "CKM_MD5_RSA_PKCS");
            ((Hashtable)serializable).put(new Long(6L), "CKM_SHA1_RSA_PKCS");
            ((Hashtable)serializable).put(new Long(7L), "CKM_RIPEMD128_RSA_PKCS");
            ((Hashtable)serializable).put(new Long(8L), "CKM_RIPEMD160_RSA_PKCS");
            ((Hashtable)serializable).put(new Long(9L), "CKM_RSA_PKCS_OAEP");
            ((Hashtable)serializable).put(new Long(10L), "CKM_RSA_X9_31_KEY_PAIR_GEN");
            ((Hashtable)serializable).put(new Long(11L), "CKM_RSA_X9_31");
            ((Hashtable)serializable).put(new Long(12L), "CKM_SHA1_RSA_X9_31");
            ((Hashtable)serializable).put(new Long(13L), "CKM_RSA_PKCS_PSS");
            ((Hashtable)serializable).put(new Long(14L), "CKM_SHA1_RSA_PKCS_PSS");
            ((Hashtable)serializable).put(new Long(16L), "CKM_DSA_KEY_PAIR_GEN");
            ((Hashtable)serializable).put(new Long(17L), "CKM_DSA");
            ((Hashtable)serializable).put(new Long(18L), "CKM_DSA_SHA1");
            ((Hashtable)serializable).put(new Long(32L), "CKM_DH_PKCS_KEY_PAIR_GEN");
            ((Hashtable)serializable).put(new Long(33L), "CKM_DH_PKCS_DERIVE");
            ((Hashtable)serializable).put(new Long(48L), "CKM_X9_42_DH_KEY_PAIR_GEN");
            ((Hashtable)serializable).put(new Long(49L), "CKM_X9_42_DH_DERIVE");
            ((Hashtable)serializable).put(new Long(50L), "CKM_X9_42_DH_HYBRID_DERIVE");
            ((Hashtable)serializable).put(new Long(51L), "CKM_X9_42_MQV_DERIVE");
            ((Hashtable)serializable).put(new Long(256L), "CKM_RC2_KEY_GEN");
            ((Hashtable)serializable).put(new Long(257L), "CKM_RC2_ECB");
            ((Hashtable)serializable).put(new Long(258L), "CKM_RC2_CBC");
            ((Hashtable)serializable).put(new Long(259L), "CKM_RC2_MAC");
            ((Hashtable)serializable).put(new Long(260L), "CKM_RC2_MAC_GENERAL");
            ((Hashtable)serializable).put(new Long(261L), "CKM_RC2_CBC_PAD");
            ((Hashtable)serializable).put(new Long(272L), "CKM_RC4_KEY_GEN");
            ((Hashtable)serializable).put(new Long(273L), "CKM_RC4");
            ((Hashtable)serializable).put(new Long(288L), "CKM_DES_KEY_GEN");
            ((Hashtable)serializable).put(new Long(289L), "CKM_DES_ECB");
            ((Hashtable)serializable).put(new Long(290L), "CKM_DES_CBC");
            ((Hashtable)serializable).put(new Long(291L), "CKM_DES_MAC");
            ((Hashtable)serializable).put(new Long(292L), "CKM_DES_MAC_GENERAL");
            ((Hashtable)serializable).put(new Long(293L), "CKM_DES_CBC_PAD");
            ((Hashtable)serializable).put(new Long(304L), "CKM_DES2_KEY_GEN");
            ((Hashtable)serializable).put(new Long(305L), "CKM_DES3_KEY_GEN");
            ((Hashtable)serializable).put(new Long(306L), "CKM_DES3_ECB");
            ((Hashtable)serializable).put(new Long(307L), "CKM_DES3_CBC");
            ((Hashtable)serializable).put(new Long(308L), "CKM_DES3_MAC");
            ((Hashtable)serializable).put(new Long(309L), "CKM_DES3_MAC_GENERAL");
            ((Hashtable)serializable).put(new Long(310L), "CKM_DES3_CBC_PAD");
            ((Hashtable)serializable).put(new Long(320L), "CKM_CDMF_KEY_GEN");
            ((Hashtable)serializable).put(new Long(321L), "CKM_CDMF_ECB");
            ((Hashtable)serializable).put(new Long(322L), "CKM_CDMF_CBC");
            ((Hashtable)serializable).put(new Long(323L), "CKM_CDMF_MAC");
            ((Hashtable)serializable).put(new Long(324L), "CKM_CDMF_MAC_GENERAL");
            ((Hashtable)serializable).put(new Long(325L), "CKM_CDMF_CBC_PAD");
            ((Hashtable)serializable).put(new Long(512L), "CKM_MD2");
            ((Hashtable)serializable).put(new Long(513L), "CKM_MD2_HMAC");
            ((Hashtable)serializable).put(new Long(514L), "CKM_MD2_HMAC_GENERAL");
            ((Hashtable)serializable).put(new Long(528L), "CKM_MD5");
            ((Hashtable)serializable).put(new Long(529L), "CKM_MD5_HMAC");
            ((Hashtable)serializable).put(new Long(530L), "CKM_MD5_HMAC_GENERAL");
            ((Hashtable)serializable).put(new Long(544L), "CKM_SHA_1");
            ((Hashtable)serializable).put(new Long(545L), "CKM_SHA_1_HMAC");
            ((Hashtable)serializable).put(new Long(546L), "CKM_SHA_1_HMAC_GENERAL");
            ((Hashtable)serializable).put(new Long(560L), "CKM_RIPEMD128");
            ((Hashtable)serializable).put(new Long(561L), "CKM_RIPEMD128_HMAC");
            ((Hashtable)serializable).put(new Long(562L), "CKM_RIPEMD128_HMAC_GENERAL");
            ((Hashtable)serializable).put(new Long(576L), "CKM_RIPEMD160");
            ((Hashtable)serializable).put(new Long(577L), "CKM_RIPEMD160_HMAC");
            ((Hashtable)serializable).put(new Long(578L), "CKM_RIPEMD160_HMAC_GENERAL");
            ((Hashtable)serializable).put(new Long(768L), "CKM_CAST_KEY_GEN");
            ((Hashtable)serializable).put(new Long(769L), "CKM_CAST_ECB");
            ((Hashtable)serializable).put(new Long(770L), "CKM_CAST_CBC");
            ((Hashtable)serializable).put(new Long(771L), "CKM_CAST_MAC");
            ((Hashtable)serializable).put(new Long(772L), "CKM_CAST_MAC_GENERAL");
            ((Hashtable)serializable).put(new Long(773L), "CKM_CAST_CBC_PAD");
            ((Hashtable)serializable).put(new Long(784L), "CKM_CAST3_KEY_GEN");
            ((Hashtable)serializable).put(new Long(785L), "CKM_CAST3_ECB");
            ((Hashtable)serializable).put(new Long(786L), "CKM_CAST3_CBC");
            ((Hashtable)serializable).put(new Long(787L), "CKM_CAST3_MAC");
            ((Hashtable)serializable).put(new Long(788L), "CKM_CAST3_MAC_GENERAL");
            ((Hashtable)serializable).put(new Long(789L), "CKM_CAST3_CBC_PAD");
            ((Hashtable)serializable).put(new Long(800L), "CKM_CAST5_KEY_GEN");
            ((Hashtable)serializable).put(new Long(800L), "CKM_CAST128_KEY_GEN");
            ((Hashtable)serializable).put(new Long(801L), "CKM_CAST5_ECB");
            ((Hashtable)serializable).put(new Long(801L), "CKM_CAST128_ECB");
            ((Hashtable)serializable).put(new Long(802L), "CKM_CAST5_CBC");
            ((Hashtable)serializable).put(new Long(802L), "CKM_CAST128_CBC");
            ((Hashtable)serializable).put(new Long(803L), "CKM_CAST5_MAC");
            ((Hashtable)serializable).put(new Long(803L), "CKM_CAST128_MAC");
            ((Hashtable)serializable).put(new Long(804L), "CKM_CAST5_MAC_GENERAL");
            ((Hashtable)serializable).put(new Long(804L), "CKM_CAST128_MAC_GENERAL");
            ((Hashtable)serializable).put(new Long(805L), "CKM_CAST5_CBC_PAD");
            ((Hashtable)serializable).put(new Long(805L), "CKM_CAST128_CBC_PAD");
            ((Hashtable)serializable).put(new Long(816L), "CKM_RC5_KEY_GEN");
            ((Hashtable)serializable).put(new Long(817L), "CKM_RC5_ECB");
            ((Hashtable)serializable).put(new Long(818L), "CKM_RC5_CBC");
            ((Hashtable)serializable).put(new Long(819L), "CKM_RC5_MAC");
            ((Hashtable)serializable).put(new Long(820L), "CKM_RC5_MAC_GENERAL");
            ((Hashtable)serializable).put(new Long(821L), "CKM_RC5_CBC_PAD");
            ((Hashtable)serializable).put(new Long(832L), "CKM_IDEA_KEY_GEN");
            ((Hashtable)serializable).put(new Long(833L), "CKM_IDEA_ECB");
            ((Hashtable)serializable).put(new Long(834L), "CKM_IDEA_CBC");
            ((Hashtable)serializable).put(new Long(835L), "CKM_IDEA_MAC");
            ((Hashtable)serializable).put(new Long(836L), "CKM_IDEA_MAC_GENERAL");
            ((Hashtable)serializable).put(new Long(837L), "CKM_IDEA_CBC_PAD");
            ((Hashtable)serializable).put(new Long(848L), "CKM_GENERIC_SECRET_KEY_GEN");
            ((Hashtable)serializable).put(new Long(864L), "CKM_CONCATENATE_BASE_AND_KEY");
            ((Hashtable)serializable).put(new Long(866L), "CKM_CONCATENATE_BASE_AND_DATA");
            ((Hashtable)serializable).put(new Long(867L), "CKM_CONCATENATE_DATA_AND_BASE");
            ((Hashtable)serializable).put(new Long(868L), "CKM_XOR_BASE_AND_DATA");
            ((Hashtable)serializable).put(new Long(869L), "CKM_EXTRACT_KEY_FROM_KEY");
            ((Hashtable)serializable).put(new Long(880L), "CKM_SSL3_PRE_MASTER_KEY_GEN");
            ((Hashtable)serializable).put(new Long(881L), "CKM_SSL3_MASTER_KEY_DERIVE");
            ((Hashtable)serializable).put(new Long(882L), "CKM_SSL3_KEY_AND_MAC_DERIVE");
            ((Hashtable)serializable).put(new Long(883L), "CKM_SSL3_MASTER_KEY_DERIVE_DH");
            ((Hashtable)serializable).put(new Long(884L), "CKM_TLS_PRE_MASTER_KEY_GEN");
            ((Hashtable)serializable).put(new Long(885L), "CKM_TLS_MASTER_KEY_DERIVE");
            ((Hashtable)serializable).put(new Long(886L), "CKM_TLS_KEY_AND_MAC_DERIVE");
            ((Hashtable)serializable).put(new Long(887L), "CKM_TLS_MASTER_KEY_DERIVE_DH");
            ((Hashtable)serializable).put(new Long(896L), "CKM_SSL3_MD5_MAC");
            ((Hashtable)serializable).put(new Long(897L), "CKM_SSL3_SHA1_MAC");
            ((Hashtable)serializable).put(new Long(912L), "CKM_MD5_KEY_DERIVATION");
            ((Hashtable)serializable).put(new Long(913L), "CKM_MD2_KEY_DERIVATION");
            ((Hashtable)serializable).put(new Long(914L), "CKM_SHA1_KEY_DERIVATION");
            ((Hashtable)serializable).put(new Long(928L), "CKM_PBE_MD2_DES_CBC");
            ((Hashtable)serializable).put(new Long(929L), "CKM_PBE_MD5_DES_CBC");
            ((Hashtable)serializable).put(new Long(930L), "CKM_PBE_MD5_CAST_CBC");
            ((Hashtable)serializable).put(new Long(931L), "CKM_PBE_MD5_CAST3_CBC");
            ((Hashtable)serializable).put(new Long(932L), "CKM_PBE_MD5_CAST5_CBC");
            ((Hashtable)serializable).put(new Long(932L), "CKM_PBE_MD5_CAST128_CBC");
            ((Hashtable)serializable).put(new Long(933L), "CKM_PBE_SHA1_CAST5_CBC");
            ((Hashtable)serializable).put(new Long(933L), "CKM_PBE_SHA1_CAST128_CBC");
            ((Hashtable)serializable).put(new Long(934L), "CKM_PBE_SHA1_RC4_128");
            ((Hashtable)serializable).put(new Long(935L), "CKM_PBE_SHA1_RC4_40");
            ((Hashtable)serializable).put(new Long(936L), "CKM_PBE_SHA1_DES3_EDE_CBC");
            ((Hashtable)serializable).put(new Long(937L), "CKM_PBE_SHA1_DES2_EDE_CBC");
            ((Hashtable)serializable).put(new Long(938L), "CKM_PBE_SHA1_RC2_128_CBC");
            ((Hashtable)serializable).put(new Long(939L), "CKM_PBE_SHA1_RC2_40_CBC");
            ((Hashtable)serializable).put(new Long(944L), "CKM_PKCS5_PBKD2");
            ((Hashtable)serializable).put(new Long(960L), "CKM_PBA_SHA1_WITH_SHA1_HMAC");
            ((Hashtable)serializable).put(new Long(1024L), "CKM_KEY_WRAP_LYNKS");
            ((Hashtable)serializable).put(new Long(1025L), "CKM_KEY_WRAP_SET_OAEP");
            ((Hashtable)serializable).put(new Long(4096L), "CKM_SKIPJACK_KEY_GEN");
            ((Hashtable)serializable).put(new Long(4097L), "CKM_SKIPJACK_ECB64");
            ((Hashtable)serializable).put(new Long(4098L), "CKM_SKIPJACK_CBC64");
            ((Hashtable)serializable).put(new Long(4099L), "CKM_SKIPJACK_OFB64");
            ((Hashtable)serializable).put(new Long(4100L), "CKM_SKIPJACK_CFB64");
            ((Hashtable)serializable).put(new Long(4101L), "CKM_SKIPJACK_CFB32");
            ((Hashtable)serializable).put(new Long(4102L), "CKM_SKIPJACK_CFB16");
            ((Hashtable)serializable).put(new Long(4103L), "CKM_SKIPJACK_CFB8");
            ((Hashtable)serializable).put(new Long(4104L), "CKM_SKIPJACK_WRAP");
            ((Hashtable)serializable).put(new Long(4105L), "CKM_SKIPJACK_PRIVATE_WRAP");
            ((Hashtable)serializable).put(new Long(4106L), "CKM_SKIPJACK_RELAYX");
            ((Hashtable)serializable).put(new Long(4112L), "CKM_KEA_KEY_PAIR_GEN");
            ((Hashtable)serializable).put(new Long(4113L), "CKM_KEA_KEY_DERIVE");
            ((Hashtable)serializable).put(new Long(4128L), "CKM_FORTEZZA_TIMESTAMP");
            ((Hashtable)serializable).put(new Long(4144L), "CKM_BATON_KEY_GEN");
            ((Hashtable)serializable).put(new Long(4145L), "CKM_BATON_ECB128");
            ((Hashtable)serializable).put(new Long(4146L), "CKM_BATON_ECB96");
            ((Hashtable)serializable).put(new Long(4147L), "CKM_BATON_CBC128");
            ((Hashtable)serializable).put(new Long(4148L), "CKM_BATON_COUNTER");
            ((Hashtable)serializable).put(new Long(4149L), "CKM_BATON_SHUFFLE");
            ((Hashtable)serializable).put(new Long(4150L), "CKM_BATON_WRAP");
            ((Hashtable)serializable).put(new Long(4160L), "CKM_ECDSA_KEY_PAIR_GEN");
            ((Hashtable)serializable).put(new Long(4160L), "CKM_EC_KEY_PAIR_GEN");
            ((Hashtable)serializable).put(new Long(4161L), "CKM_ECDSA");
            ((Hashtable)serializable).put(new Long(4162L), "CKM_ECDSA_SHA1");
            ((Hashtable)serializable).put(new Long(4176L), "CKM_ECDH1_DERIVE");
            ((Hashtable)serializable).put(new Long(4177L), "CKM_ECDH1_COFACTOR_DERIVE");
            ((Hashtable)serializable).put(new Long(4178L), "CKM_ECMQV_DERIVE");
            ((Hashtable)serializable).put(new Long(4192L), "CKM_JUNIPER_KEY_GEN");
            ((Hashtable)serializable).put(new Long(4193L), "CKM_JUNIPER_ECB128");
            ((Hashtable)serializable).put(new Long(4194L), "CKM_JUNIPER_CBC128");
            ((Hashtable)serializable).put(new Long(4195L), "CKM_JUNIPER_COUNTER");
            ((Hashtable)serializable).put(new Long(4196L), "CKM_JUNIPER_SHUFFLE");
            ((Hashtable)serializable).put(new Long(4197L), "CKM_JUNIPER_WRAP");
            ((Hashtable)serializable).put(new Long(4208L), "CKM_FASTHASH");
            ((Hashtable)serializable).put(new Long(4224L), "CKM_AES_KEY_GEN");
            ((Hashtable)serializable).put(new Long(4225L), "CKM_AES_ECB");
            ((Hashtable)serializable).put(new Long(4226L), "CKM_AES_CBC");
            ((Hashtable)serializable).put(new Long(4227L), "CKM_AES_MAC");
            ((Hashtable)serializable).put(new Long(4228L), "CKM_AES_MAC_GENERAL");
            ((Hashtable)serializable).put(new Long(4229L), "CKM_AES_CBC_PAD");
            ((Hashtable)serializable).put(new Long(8192L), "CKM_DSA_PARAMETER_GEN");
            ((Hashtable)serializable).put(new Long(8193L), "CKM_DH_PKCS_PARAMETER_GEN");
            ((Hashtable)serializable).put(new Long(8194L), "CKM_X9_42_DH_PARAMETER_GEN");
            ((Hashtable)serializable).put(new Long(0x80000000L), "CKM_VENDOR_DEFINED");
            mechansimNames_ = serializable;
        }
        String string = (v = mechansimNames_.get(serializable = new Long(l))) != null ? v.toString() : "Unknwon mechanism with code: 0x" + Functions.toFullHexString(l);
        return string;
    }

    public static String mechanismInfoFlagsToString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if ((l & 1L) != 0L) {
            stringBuffer.append("CKF_HW");
            bl = true;
        }
        if ((l & 0x100L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_ENCRYPT");
            bl = true;
        }
        if ((l & 0x200L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_DECRYPT");
            bl = true;
        }
        if ((l & 0x400L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_DIGEST");
            bl = true;
        }
        if ((l & 0x800L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_SIGN");
            bl = true;
        }
        if ((l & 0x1000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_SIGN_RECOVER");
            bl = true;
        }
        if ((l & 0x2000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_VERIFY");
            bl = true;
        }
        if ((l & 0x4000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_VERIFY_RECOVER");
            bl = true;
        }
        if ((l & 0x8000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_GENERATE");
            bl = true;
        }
        if ((l & 0x10000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_GENERATE_KEY_PAIR");
            bl = true;
        }
        if ((l & 0x20000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_WRAP");
            bl = true;
        }
        if ((l & 0x40000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_UNWRAP");
            bl = true;
        }
        if ((l & 0x80000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_DERIVE");
            bl = true;
        }
        if ((l & 0x100000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_EC_F_P");
            bl = true;
        }
        if ((l & 0x200000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_EC_F_2M");
            bl = true;
        }
        if ((l & 0x400000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_EC_ECPARAMETERS");
            bl = true;
        }
        if ((l & 0x800000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_EC_NAMEDCURVE");
            bl = true;
        }
        if ((l & 0x1000000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_EC_UNCOMPRESS");
            bl = true;
        }
        if ((l & 0x2000000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_EC_COMPRESS");
            bl = true;
        }
        if ((l & 0x80000000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_EXTENSION");
            bl = true;
        }
        return stringBuffer.toString();
    }

    public static String sessionInfoFlagsToString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if ((l & 2L) != 0L) {
            stringBuffer.append("CKF_RW_SESSION");
            bl = true;
        }
        if ((l & 4L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_SERIAL_SESSION");
        }
        return stringBuffer.toString();
    }

    public static String sessionStateToString(long l) {
        String string = l == 0L ? "CKS_RO_PUBLIC_SESSION" : (l == 1L ? "CKS_RO_USER_FUNCTIONS" : (l == 2L ? "CKS_RW_PUBLIC_SESSION" : (l == 3L ? "CKS_RW_USER_FUNCTIONS" : (l == 4L ? "CKS_RW_SO_FUNCTIONS" : "ERROR: unknown session state 0x" + Functions.toFullHexString(l)))));
        return string;
    }

    public static String slotInfoFlagsToString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if ((l & 1L) != 0L) {
            stringBuffer.append("CKF_TOKEN_PRESENT");
            bl = true;
        }
        if ((l & 2L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_TOKEN_PRESENT");
            bl = true;
        }
        if ((l & 4L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_HW_SLOT");
        }
        return stringBuffer.toString();
    }

    public static String toBinaryString(long l) {
        return Long.toString(l, 2);
    }

    public static String toBinaryString(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        return bigInteger.toString(2);
    }

    public static String toFullHexString(int n) {
        int n2 = n;
        StringBuffer stringBuffer = new StringBuffer(8);
        int n3 = 0;
        while (n3 < 8) {
            int n4 = n2 & 0xF;
            stringBuffer.append(HEX_DIGITS[n4]);
            n2 >>>= 4;
            ++n3;
        }
        return stringBuffer.reverse().toString();
    }

    public static String toFullHexString(long l) {
        long l2 = l;
        StringBuffer stringBuffer = new StringBuffer(16);
        int n = 0;
        while (n < 16) {
            int n2 = (int)l2 & 0xF;
            stringBuffer.append(HEX_DIGITS[n2]);
            l2 >>>= 4;
            ++n;
        }
        return stringBuffer.reverse().toString();
    }

    public static String toHexString(long l) {
        return Long.toHexString(l);
    }

    public static String toHexString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(2 * byArray.length);
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n] & 0xFF;
            if (n2 < 16) {
                stringBuffer.append('0');
            }
            stringBuffer.append(Integer.toString(n2, 16));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String tokenInfoFlagsToString(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        if ((l & 1L) != 0L) {
            stringBuffer.append("CKF_RNG");
            bl = true;
        }
        if ((l & 2L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_WRITE_PROTECTED");
            bl = true;
        }
        if ((l & 4L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_LOGIN_REQUIRED");
            bl = true;
        }
        if ((l & 8L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_USER_PIN_INITIALIZED");
            bl = true;
        }
        if ((l & 0x20L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_RESTORE_KEY_NOT_NEEDED");
            bl = true;
        }
        if ((l & 0x40L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_CLOCK_ON_TOKEN");
            bl = true;
        }
        if ((l & 0x100L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_PROTECTED_AUTHENTICATION_PATH");
            bl = true;
        }
        if ((l & 0x200L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_DUAL_CRYPTO_OPERATIONS");
            bl = true;
        }
        if ((l & 0x400L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_TOKEN_INITIALIZED");
            bl = true;
        }
        if ((l & 0x800L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_SECONDARY_AUTHENTICATION");
            bl = true;
        }
        if ((l & 0x10000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_USER_PIN_COUNT_LOW");
            bl = true;
        }
        if ((l & 0x20000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_USER_PIN_FINAL_TRY");
            bl = true;
        }
        if ((l & 0x40000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_USER_PIN_LOCKED");
            bl = true;
        }
        if ((l & 0x80000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_USER_PIN_TO_BE_CHANGED");
            bl = true;
        }
        if ((l & 0x100000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_SO_PIN_COUNT_LOW");
            bl = true;
        }
        if ((l & 0x200000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_SO_PIN_FINAL_TRY");
            bl = true;
        }
        if ((l & 0x400000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_USER_PIN_FINAL_TRY");
            bl = true;
        }
        if ((l & 0x800000L) != 0L) {
            if (bl) {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("CKF_USER_PIN_LOCKED");
            bl = true;
        }
        return stringBuffer.toString();
    }
}

